---
generated_at: 2026-01-29 21:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-What's New画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/admin/app/routes/whatsnew.js` - What's Newルート
- E-02: `ghost/admin/app/controllers/whatsnew.js` - What's Newコントローラー
- E-03: `ghost/admin/app/templates/whatsnew.hbs` - What's Newテンプレート
- E-04: `ghost/admin/app/services/whats-new.js` - What's Newサービス
- E-05: `ghost/admin/app/routes/authenticated.js` - 認証済みルート基底クラス
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL: /ghost/whatsnew | E-01, E-06 | ○ |
| C-02 | AuthenticatedRouteを継承 | E-01 (1行目, 3行目) | ○ |
| C-03 | whatsNewサービスを使用 | E-02 (5行目), E-03 (8行目, 9行目) | ○ |
| C-04 | ghost.org/changelog.jsonからデータ取得 | E-04 (89行目) | ○ |
| C-05 | changelogUrl: https://ghost.org/blog/ | E-04 (12行目) | ○ |
| C-06 | did-insertでupdateLastSeen実行 | E-03 (8行目) | ○ |
| C-07 | moment-formatで"DD MMMM YYYY"形式表示 | E-03 (12行目) | ○ |
| C-08 | フィーチャー画像の条件付き表示 | E-03 (14-16行目) | ○ |
| C-09 | custom_excerptまたはhtml表示 | E-03 (19-24行目) | ○ |
| C-10 | hasNewで新着判定（latestMoment > lastSeenMoment） | E-04 (31-41行目) | ○ |
| C-11 | hasNewFeaturedでフィーチャード判定 | E-04 (43-50行目) | ○ |
| C-12 | _changelog_responseでキャッシュ | E-04 (66-69行目) | ○ |
| C-13 | 新規ユーザーにデフォルトlastSeenDate設定 | E-04 (26-28行目, 77-82行目) | ○ |
| C-14 | updateLastSeenでaccessibility更新 | E-04 (103-122行目) | ○ |
| C-15 | user.save()で永続化 | E-04 (82行目, 121行目) | ○ |
| C-16 | 通知登録ボタンでghost.org/changelog/#/portal/signupへ | E-03 (4行目) | ○ |
| C-17 | 全更新表示リンクでghost.org/changelogへ | E-03 (28行目) | ○ |
| C-18 | 管理者通知（機能No.62）に関連 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に対して十分な根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**：外部API依存 - changelog.jsonの取得は明確に実装
- **0（低リスク）**：状態管理 - accessibilityへの保存ロジックは明確
- **0（低リスク）**：新着判定 - computed propertyで明確に実装

## 6) レビュアーチェックリスト（最小）

- [ ] ghost.org/changelog.jsonの可用性を確認
- [ ] 新規ユーザーのデフォルトlastSeenDate設定が正しく動作するか確認
- [ ] updateLastSeenのuser.save()が失敗した場合の挙動を確認
- [ ] hasNew判定のタイムゾーン処理を確認（moment-timezone使用）
- [ ] フィーチャードエントリーのモーダル表示機能（isShowingModal）の動作確認
